// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

#include <mapi.h>
#include <richole.h>

// Prototype header file for Top Secret Crypto.
//.............................................
LRESULT CALLBACK WndProc(HWND hWin, UINT Msg, WPARAM wParm, LPARAM lParm);

// About always returns TRUE.
//...........................
LRESULT CALLBACK About(HWND hWin, UINT Msg, WPARAM wParm, LPARAM lParm);

// Initialize returns FALSE if we could not initialize everything,
// and TRUE if we could.
//................................................................
LRESULT CALLBACK InitializeTSC(HWND hWin);

// UpdateRandBitsBinFile returns TRUE if the file got updated,
// and FALSE if there was an error.
//............................................................
LRESULT CALLBACK UpdateRandBitsBinFile();

// Sets up our MSGBOXPARAMS structure with some default values.
// dwLangId must be specified. The others may be null. The call
// back function is only used for context sensitive help.
//.............................................................
VOID MessageBoxSetup(DWORD dwLangId, MSGBOXCALLBACK lpfnMsgBoxCallBack, DWORD dwContextHelpId);

// MessageBoxProc returns the result of the MessageBoxIndirect
// Function. Used for most of our message boxes.
//............................................................
int MessageBoxProc(HWND hWin, UINT Title, UINT Text, UINT Style, UINT Beep, LPCTSTR lpIcon);

// RandBitsBinThread always returns TRUE when it exits.
//.....................................................
DWORD WINAPI RandomBitsBinThread(HWND hWin);

// CenterWindow returns the result of the SetWindowPos function.
//..............................................................
BOOL CenterWindow (HWND hChild, HWND hParent);

// StirTheBits stirs up all the bits in the Random Bits Bin
// at one time.
//.........................................................
VOID StirTheBits();

// ErrorProcedure returns the results of a MessageBox function.
//.............................................................
LRESULT ErrorProcedure(LPTSTR lpFile, DWORD dwOperation, UINT uButtons);

// CreateMyFile returns a handle to the file or FALSE for cancel.
//...............................................................
HANDLE CALLBACK CreateMyFile(LPTSTR FileName, DWORD Access, DWORD sMode,
							 LPSECURITY_ATTRIBUTES Sec_Atribs,
							 DWORD Create_Mode, DWORD Attribs,HANDLE TemplateFile);

// ReadMyFile returns TRUE if successful, and FALSE for cancel.
// If TRUE, the number of bytes read, which may be 0, will be in
// the bytes read variable.
//..............................................................
BOOL CALLBACK ReadMyFile(LPTSTR FileName, HANDLE hFile, LPVOID lpvBuf,
						 DWORD BytesToRead, LPDWORD BytesRead, LPOVERLAPPED lpLapped);

// WriteMyFile returns TRUE is successful, and FALSE for cancel.
// If TRUE, the number of bytes written will be in the bytes
// written variable.
//..............................................................
BOOL CALLBACK WriteMyFile(LPTSTR FileName, HANDLE hFile, LPCVOID lpcBuf,
						  DWORD BytesToWrite, LPDWORD BytesWritten, LPOVERLAPPED lpLapped);

// CloseMyHandle returns TRUE if successful, and FALSE for cancel.
// File should be set to the full path name for a file, or the
// name of the object you are closing.
//................................................................
BOOL CALLBACK CloseMyHandle(LPTSTR FileName, HANDLE hObject);

// SetMyFilePointer returns the file pointer asked for in a 
// LARGE_INTEGER structure. If the LARGE_INTEGER is -1 there
// was an error. Cancel the procedure.
//..........................................................
__int64 CALLBACK SetMyFilePointer(LPTSTR FileName, HANDLE hFile,
								  __int64 DistanceToMove,DWORD Method);

// Get the size of a file. Handles all file sizes. Returns -1 in a
// LARGE_INTEGER structure if there was an error.
//................................................................
__int64 GetMyFileSize(LPTSTR FileName, HANDLE hFile);

// Delete the designated file. Return TRUE if successful,or
// FALSE is we have an error.
//.........................................................
BOOL CALLBACK DeleteMyFile(LPTSTR FileName);

// Common dialog box function error procedures.
// If we have an error, we have to cancel the procedure because
// more than likely we do not have enough system resources to
// continue with the program. If we get into this function we
// had an error or we cancelled the function.
//.............................................................
VOID CommDlgBoxErrorProc(DWORD DlgBoxType);

// PrintPadInstruction prints the instructions for the One Time Pad.
//..................................................................
BOOL PrintPadInstructions();

// AbortPrintJob is used by SetAbortProc when printing.
//.....................................................
BOOL CALLBACK AbortPrintJob(HDC hdcPrinter, int Code);

// Initialize and get a printer DC using the common dialog 
// control PrintDlg.
//..................................................................
HDC GetPrinterDC(HWND hWnd, DWORD dwFlags, DWORD dwFromPage,
				 DWORD dwToPage, DWORD dwMinPages, DWORD dwMaxPages, DWORD dwCopies);

// Dialog procedure for the printer about dialog box.
//...................................................
LRESULT CALLBACK AbortPrintDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);

// Create the only font we will use in the program.
//.................................................
HFONT CreateMyFont(HDC hDC);

// Get the number of requested random bits from the random bits bin
// and place them in the destination operand.
//.................................................................
VOID GetRandomBits(DWORD BitsRequired,LPVOID Destination);

// Make a One Time Pad.
//.....................
BOOL MakeAOneTimePad();

// Initialize an OPENFILENAME structure.
//......................................
VOID InitializeOFN(LPOPENFILENAME lpofn, DWORD dwInitialDir);

// Hook procedure for the GetOpenFileName, GetSaveFileName functions.
//...................................................................
UINT CALLBACK MyOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Procedure to check to see if we have a valid OTP Key File.
//...........................................................
HANDLE IsValidOTPKeyFile(LPTSTR lpFileName);

// Allocate memory with the GMEM_FIXED flag. The
// returned pointer is equal to the memory handle.
//................................................
LPVOID AllocateMemory(DWORD dwMemRequested);

// Deallocate memory. The pointer is equal to the handle.
//.......................................................
BOOL DeallocateMemory(HGLOBAL hMem);

// Callback for getting the Pad ID.
//.................................
LRESULT CALLBACK PadIDProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);

// Set the selected icon in all dialog box caption bars.
//......................................................
VOID SetMyIcon(HWND hDlg);

// Common print dialog box hook procedure.
//........................................
UINT CALLBACK PrtDlgHookProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);

// Create an up down control, a spin box, in a dialog box.
//........................................................
HWND CreateMySpinBox(DWORD dwStyles, int x, int y, int width, int height,
					 HWND hWndParent, int iControlID, HWND hWndBuddy,
					 int iMax, int iMin, int iInitial);

// Get a pseudo random number.
//............................
DWORD GetRandomNumber();

// Get a pseudo random number. Only used to 
// setup our 3 arrays.
//.........................................
DWORD GetRandNum();

// Set the random factor array shift value.
//.........................................
VOID SetRFShiftValue(LPVOID lpBuffer);

// Setup the arrays for the pseudo random number generators.
//..........................................................
VOID SetupArrays(LPVOID lpBuffer);

// Fill one array with randomly selected numbers.
//...............................................
VOID FillOneArray(LPVOID lpBuffer, LPVOID lpArray);

// Fill the key line with randomly generated characters in
// the range of A to Z and -.
//........................................................
VOID FillPadLine();

// DateToJulian converts a given year, month, and day to a
// julian day number, which is returned in eax.
//........................................................
DWORD DateToJulian(LPSYSTEMTIME lpst);

// JulianToDate converts an astronomical julian day number into
// a conventional date in a SYSTEMTIME structure.
//.............................................................
VOID JulianToDate(LPSYSTEMTIME lpst, DWORD JulianDay);

// Return a GMT or local timestamp in based on the number of seconds
// from 1 Jan. 1970.
//..................................................................
__int64 GetTimestamp(BOOL bGmt);

// Multiprecision decrement function. Works on DWORDS.
//....................................................
VOID MpDecDW(LPBYTE lpOperand, DWORD dwOpDwords);

// Multiprecision increment function. Works on DWORDS.
//....................................................
VOID MpIncDW(LPBYTE lpOperand, DWORD dwOpDwords);

// Rotate a bit field left the number of bits passed. Takes
// the end bit and rotates it into the first bit of the string.
//.............................................................
VOID RotateBitFieldLeft(LPBYTE lpBitField, DWORD dwByteCount, DWORD dwShiftCount);

// Rotate a bit field right the number of bits passed. Takes
// the first bit and rotates it into the last bit of the string.
//..............................................................
VOID RotateBitFieldRight(LPBYTE lpBitField, DWORD dwByteCount, DWORD dwShiftCount);

// Perform a checksum on a MPI nubmer. Since it is a plain
// addition checksum it does not matter what order it is in.
// Returns 16 bit checksum in a dword.
//..........................................................
DWORD CheckSum(LPBYTE lpOperand, DWORD dwByteCount);

// Circle swap reverses the order of bytes in an array.
//.....................................................
VOID CircleSwap(LPBYTE lpOperand, DWORD dwByteCount);

// Multiprecision add function. Works on dwords.
//..............................................
VOID MpAddDW(LPBYTE lpDestination, LPBYTE lpSource, DWORD dwDwordCount);

// Multiprecision subtract function. Works on dwords.
// Returns TRUE is underflow, else FALSE.
//...................................................
BOOL MpSubDW(LPBYTE lpDestination, LPBYTE lpSource, DWORD dwDwordCount);

// Count the bits, bytes, and dwords in a multiprecision number.
// Returns values in dwCountBits, dwCountBytes, and dwCountDwords.
//................................................................
VOID CountBBD(LPBYTE lpOperand, DWORD dwByteCount);

// Compare two multiprecision numbers. Works on dwords.
// Returns 0 if the two are equal. 1 if destination is 
// larger than the source. -1 if destination is smaller
// than the source.
//.....................................................
DWORD MpCompareDW(LPBYTE lpSource, LPBYTE lpDestination, DWORD dwDwordCount);

// Shift left a multiprecison number by 1, thereby
// multiplying it by 2. Works on dwords.
//................................................
VOID MpShlDW(LPBYTE lpOperand, DWORD dwDwordCount);

// Shift right a multiprecision number by 1, thereby
// dividing it by 2. Works on dwords.
//..................................................
VOID MpShrDW(LPBYTE lpOperand, DWORD dwDwordCount);

// Multiprecision multiply function. Works on dwords.
//...................................................
BOOL MpMultDW(LPBYTE lpProduct, LPBYTE lpMultiplicand, 
			  LPBYTE lpMultiplier, DWORD dwMultiplicandDwords, DWORD dwMultiplierDwords);

// Encipher the secret components of the secret key. The correct
// pass phrase is required to decipher it.
//..............................................................
BOOL EncipherSecretComponents(LPBYTE lpPassPhrase, LPBYTE lpSecretComponents,
							  DWORD dwPPCount, DWORD dwSCCount);

// Decipher the secret components of the secret key. The correct
// pass phrase is required.
//..............................................................
BOOL DecipherSecretComponents(LPBYTE lpPassPhrase, LPBYTE lpSecretComponents,
							  DWORD dwPPCount, DWORD dwSCCount);

// Multiprecision fast mod operation using a short 16 bit modulus.
// Returns 16 bit remainder.
//................................................................
DWORD MpShortMod(LPBYTE lpDividend, DWORD dwDivisor, DWORD dwBits);

// Build a table of remainders relative to our random prime
// suspect for use by the fast sieve function. Returns FALSE
// if we have an error.
//.........................................................
BOOL BuildSieve(LPBYTE lpPrimeSuspect, DWORD dwBits, LPBYTE lpPrimesTable,
				LPBYTE lpRemaindersTable, DWORD dwEntries);

// Fast sieve tests a suspected number for being prime. After a
// suspected number passes the fast sieve it should be further
// tested via Fermat's theorem. Returns TRUE if number passes
// the fast sieve, else FALSE.
//..............................................................
BOOL FastSieve(DWORD dwPDelta, LPBYTE lpPrimeTable, LPBYTE lpRemaindersTable);

// Fill the prime table with small 16 bit prime numbers to use
// in the fastsieve function.
//............................................................
BOOL FillPrimeTable(LPBYTE lpPrimeTable, DWORD dwPrimesRequired);

// FermatTest conducts 4 tests on our suspected prime number.
// All temporary variables must accomodate the largesty expected
// numbers. Once a candidate number has passed 4 Fermat tests it
// is considered prime.
//
// Calculates: If ((X^(P-1)) MOD P) != 1 the number is not prime.
//
// Uses: Temp2, Temp3, and Temp5.
//
// Returns: FALSE if number is not prime, and TRUE is it is.
//...............................................................
BOOL FermatTest(LPBYTE lpPrimeCandidate, LPBYTE lpPrimeTable, DWORD dwPrimeBytes);

// RsaPubDec decrypts a block of data equal to the size of modulus n
// using your public key. EXP_E and Modulus n must not be destroyed.
// Checking only needs to de done for signatures on the various sizes
// of the variables. This is done before the function is entered.
//
// We only support the new message digest packet format for PGP 2.3
// and later.
//
// Uses: Temp5
//
// Returns: Decrypted data in OutBuff. dwCountBytes = byte count
//          of data. Returns TRUE is we have an error, else FALSE.
//...................................................................
BOOL RsaPubDec(LPBYTE lpOutBuff, LPBYTE lpInBuff, LPBYTE lpExpE,
			   LPBYTE lpModN, DWORD dwModNBytes);

// RsaPubEnc encrypts a block of data equal to the size of Modulus
// n using your public key.
//
// We only support the new conventional DEK packet format
// in PGP 2.3 and later.
//
// Uses: Temp5, and Temp9.
//
// OutBuff must be MAX_MOD_SLOP in length.
//
// Returns: Encrypted block in OutBuff. Bit, byte and dword
//          counts in their respective places.
//................................................................
VOID RsaPubEnc(LPBYTE lpOutBuff, LPBYTE lpInBuff, DWORD dwInBytes,
			   LPBYTE lpExpE, LPBYTE lpModN, DWORD dwModNBytes);

// RsaPriEnc encrypts a block of data equal to the size of Modulus n
// using your secret key. Anyone with your public key can decrypt the
// data. Exp e and Mod n not required because we use ModExpCrt. Since
// this procedure is only used internally checking for proper size
// of the variables in not done.
//
// We only support the new message digest packet format in PGP 2.3
// and later.
//
// Uses: Temp9, and uses Temp1 for OutBuff.
//       OutBuff must be MAX_MOD_SLOP in length.
//
// lpPPrime, lpQPrime, lpDExp, and lpInvU must not be destroyed.
//
// Returns: Encrypted block in OutBuff. Bit, byte, and dword
//          counts returned in their respective variables.
//...................................................................
BOOL RsaPriEnc(LPBYTE lpOutBuff, LPBYTE lpInBuff, DWORD dwInBytes, LPBYTE lpDExp, 
			   LPBYTE lpPPrime, LPBYTE lpQPrime, LPBYTE lpInvU, DWORD dwModNBytes);

// Clear encryption variables, Temp1 through Temp9.
//.................................................
VOID ClearEncVariables();

// Clear all variables.
//.....................
VOID ClearAllVariables();

// Clear variables for decryption.
//................................
VOID ClearDecryptVariables();

// RsaPriDec decrypts a block of data equal to the size of Modulus
// n using your secret key. Exp e and Mod n not required because
// we use ModExpCrt.
//
// We only support the new conventional DEK packet format for
// PGP 2.3 and later.
//
// OutBuff must be MAX_MOD_SLOP in length.
//
// Entry: InBuff in Temp9.
//
// Uses: Temp5 and Temp9.
//
// Returns: Decrypted data in OutBuff and byte count in dwCountBytes.
//          Returns TRUE if we have an errro, else FALSE.
//...................................................................
BOOL RsaPriDec(LPBYTE lpOutBuff, LPBYTE lpInBuff, LPBYTE lpDExp,
			   LPBYTE lpPPrime, LPBYTE lpQPrime, LPBYTE lpInvU, DWORD dwModNBytes);

// Rsa Key Generation function.
//.............................
BOOL RsaKeyGeneration();

// CALLBACK procedure for the Rsa Key Generation Setup dialog box.
//................................................................
LRESULT CALLBACK RsaKeySetupProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for the Rsa Key Generation dialog box.
//..........................................................
LRESULT CALLBACK RsaKeyGenProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Check for messages while a modeless dialog box is displayed and 
// we are doing lengthly processing.
//................................................................
VOID CheckForMessages();

// Trap the tab key using the keyboard hook procedure.
//....................................................
LRESULT CALLBACK TrapTabKey(int nCode, WPARAM wParam, LPARAM lParam);

// Trap the tab key using the keyboard hook procedure so we can
// switch between windows.
//..............................................................
LRESULT CALLBACK TrapViewTabKey(int nCode, WPARAM wParam, LPARAM lParam);

// Trap mouse input to keep the focus on the cancel button.
//.........................................................
LRESULT CALLBACK TrapMouseInput(int nCode, WPARAM wParam, LPARAM lParam);

// 1 second timer callback function. Used to display elapsed time
// on the status bar.
//...............................................................
VOID CALLBACK My1SecondTimer(HWND hWnd, UINT uTimerMsg, UINT uTimerID, DWORD dwTime);

// Flash task bar icon entry for attention at 1 second intervals.
// Timer callback function.
//...............................................................
VOID CALLBACK FlashIconTimer(HWND hWnd, UINT uTimerMsg, UINT uTimerID, DWORD dwTime);

// Flashes the task bar icon until we restore it. If bNotify is
// true we always play a sound. Else the sound is only played
// if the program is minimized.
//...............................................
VOID FlashMyIcon(BOOL bNotifyMe);

// Format a number for output. Returns the formated string.
//.........................................................
VOID FormatMyNumber(DWORD dwNumber,LPTSTR lpOutPut, DWORD dwSize);

// Primes p and q fermat test progress functions.
//...............................................
VOID PrimePFermatProgress();
VOID PrimeQFermatProgress();

// Print status information for Primes p and q generation.
//........................................................
VOID PrimePStatus();
VOID PrimeQStatus();

// Find a large random prime number. Returns FALSE if error or quit.
// Bits, bytes, and dwords in appropriate places.
//..................................................................
BOOL GetRandomPrimeNumber(LPBYTE lpPrimeSuspect, DWORD dwBitsRequired);

// Swap two fields in memory.
//...........................
VOID SwapOps(LPBYTE lpOperand1, LPBYTE lpOperand2, DWORD dwByteCount);

// Display the bits for primes p and q in the dialog box.
//.......................................................
VOID DisplayPQBits();

// See if we have another process in progress. If so, we cannot
// start something else. Returns TRUE if we have a process going.
//...............................................................
BOOL ProcessInProgress();

// CALLBACK procedure for the AskForKeyRings dialog box.
//......................................................
LRESULT CALLBACK AskForKeyRings(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Load a set of Public and Secret Key rings.
// Returns TRUE if a set is loaded, else FALSE.
//.............................................
BOOL LoadASetOfKeyRings(BOOL bProcessRunning, BOOL bCalledFromRsaKeyGen, HWND hParentWindow);

// Create a new set of Public and Secret Key rings.
// Returns TRUE if a new set is created, else FALSE.
//..................................................
BOOL CreateANewSetOfKeyRings();

// Displays context sensitive help topics for the program.
//........................................................
VOID DisplayMyHelp(HWND hWnd);

// Change the help topic. Returns the old topic number
// which should be replaced at the end of a procedure.
//.....................................................
DWORD ChangeHelpTopic(DWORD dwNewHelpTopic);

// Close the key ring and index files.
// Returns TRUE if no error, else FALSE.
//......................................
BOOL CloseAllKeyRingFiles();

// Delete the index files.
//........................
VOID DeleteIndexFiles();

// Rewind all the key ring and index files to their beginning.
// Returns TRUE if no error, else FALSE.
//............................................................
BOOL RewindAllKeyRingFiles();

// Initilaize the Md5 state and bit count.
//........................................
VOID Md5Initialize(LPMD5_CTX lpMd5Context);

// Update the Md5 context state to reflect the addition of
// another buffer full of data.
//........................................................
VOID Md5Update(LPMD5_CTX lpMd5Context, LPBYTE lpInBuffer, DWORD dwBufferLength);

// Md5Transform is the core of the Md5 algorithm.
// Only called from within Md5Update and Md5Final.
//................................................
VOID Md5Transform(LPMD5_CTX lpMd5Context, LPBYTE lpMd5Buffer);

// Md5Final takes care of any remaining bytes and the bit count.
//..............................................................
VOID Md5Final(LPBYTE lpDigest, LPMD5_CTX lpMd5Context);

// SignMyKey uses lpKeyBuffer2 to build the parts to calculate
// the Md5 message digest.
// 
// Entry: Public Key in lpKeyBuffer1 and size of public key
//        packet in dwPublicComp. User Id in szUserID if needed.
//        p, q, d, u, and n bytes initialized.
//
// Exit: Signature in lpKeyBuffer2 and size of signature in
//       dwSignatureSize.
//..............................................................
VOID SignMyKey(DWORD dwTypeOfSignature);

// Perform a shell sort on a table of structured data. Sort in any
// direction and on signed data (with restrictions).
//................................................................
VOID ShellSort(LPBYTE lpTable, DWORD dwRecordCount,
			   LPSORT_TEMPLATE lpSortParameters, DWORD dwDirection);

// SortMyFile determines if a file can be sorted in memory or not
// and calls the correct function to sort the file based on this
// determination.
//...............................................................
BOOL SortMyFile(LPTSTR FileName, HANDLE hFile, DWORD dwHeaderBytes,
				LPSORT_TEMPLATE lpSortParameters, DWORD dwDirection);

// Sort a file in memory if we have enough. Returns TRUE if
// successful, else FALSE. Sort in any direction and on signed
// data (with restrictions).
//............................................................
BOOL SortFileInMemory(LPTSTR FileName, HANDLE hFile, LPBYTE lpBuffer,
					  LPSORT_TEMPLATE lpSortParameters,
					  DWORD dwRecordCount, DWORD dwFileSize,
					  DWORD dwHeaderBytes, DWORD dwDirection);

// Sort a file on disk because we do not have enough memory to
// read the whole file and sort it in memory.
//............................................................
BOOL SortFileOnDisk(LPTSTR FileName, HANDLE hFile,
					LPSORT_TEMPLATE lpSortParameters,
				    DWORD dwRecordCount, DWORD dwFileSize,
					DWORD dwHeaderBytes, DWORD dwDirection);

// Index or reindex the public and secret key rings.
// Assumes key ring files are open. Index files may not
// be open if this is a new set of key rings.
//.....................................................
BOOL IndexKeyRingFiles(HWND hParentWindow);

// CALLBACK procedure for the Index Key Rings dialog box.
//.......................................................
LRESULT CALLBACK IndexKeyRingsProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// GetPcktLength puts the length of the packet in eax
// depending on the size of the length field.
//
// Exit:  eax = length of packet.
//        edx = length of length field.
//...................................................
VOID GetPcktLength(LPBYTE lpBuffer, DWORD dwCTB_BYTE);

// Return the length of the packet in eax.
//
// Exit:  eax = length of packet.
//        edx = length of length field.
//........................................
VOID GetPcktLgth(LPBYTE lpBuffer, DWORD dwSizeOfLengthField);

// Copy a file to a new directory.
//................................
BOOL CopyMyFile(LPCTSTR lpExistingFile, LPCTSTR lpNewFile, BOOL bFailifExists);

// Flush the file buffers for the specified file to disk.
//.......................................................
BOOL FlushMyFile(LPTSTR FileName, HANDLE hFile);

// Flush all key ring and index file buffers to disk.
//...................................................
BOOL FlushAllFiles();

// Enable or disable menu items and toolbar buttons depending on
// the status of loaded key rings. Set bState to TRUE to enable
// the menu items, and FALSE to disable them.
//..............................................................
VOID EnableAllMenuItems(BOOL bState);

// Check for 0 length key ring files. If we find one, close and 
// delete it, and close and delete all index files. Returns 
// FALSE if we had a 0 length key ring file or disk error, in
// which case all the files will be closed. Returns TRUE if
// no 0 length key ring file.
//.............................................................
BOOL CheckForZeroLengthFiles();

// Setup Group One or Two variables for use by
// various procedures.
//............................................
VOID SetUpGroup(DWORD dwKeyType, DWORD dwIndexType, DWORD dwGroup);

// Read one key from a public or secret key ring into
// memory in lpKeyBuffer1. Returns -1 if error, else
// the number of bytes read.
//...................................................
DWORD ReadRecord1();

// Read one key from a public or secret key ring into
// memory in lpKeyBuffer2. Returns -1 if error, else
// the number of bytes read.
//...................................................
DWORD ReadRecord2();

// Write 1 key from lpKeyBuffer1 into a public or secret key ring.
// Returns FALSE if error.
//................................................................
BOOL WriteRecord1();

// Write 1 key from lpKeyBuffer2 into a public or secret key ring.
// Returns FALSE if error.
//................................................................
BOOL WriteRecord2();

// Read one record from an index file into memory.
// Return -1 if we have an error, else the number
// of bytes read.
//................................................
DWORD ReadIndex1();

// Read one record from an index file into memory.
// Return -1 if we have an error, else the number
// of bytes read.
//................................................
DWORD ReadIndex2();

// Determine if a file can be searched in memory or on disk and
// call the appropriate function. Performs a binary search.
//
// Returns: Large integer = -1 if an error occured.
//          LowPart = TRUE if a match is found and Highpart =
//          position in file where the match was found.
//          Large integer = FALSE if no match found.
//..............................................................
__int64 SearchMyFileBinary(LPBYTE lpFileName, LPBYTE lpSearchString,
						   DWORD dwSizeOfString, HANDLE hFile, 
						   DWORD dwHeaderBytes,LPSEARCH_TEMPLATE lpSearchParameters);

// Perform a binary search on a structured file to find the first
// match for the search string.
//
// Returns: Large integer = -1 if an error occured.
//          LowPart = TRUE if a match is found and Highpart =
//          position in file where the match was found.
//          Large integer = FALSE if no match found.
//...............................................................
__int64 SearchFileBinaryOnDisk(LPBYTE lpFileName, LPBYTE lpSearchString,
							   DWORD dwSizeOfString, HANDLE hFile, DWORD dwHeaderBytes,
							   LPSEARCH_TEMPLATE lpSearchParameters,DWORD dwRecordCount);

// Perform a binary search on a structured file to find the first
// match for the search string.
//
// Returns: Large integer = -1 if an error occured.
//          LowPart = TRUE if a match is found and Highpart =
//          position in file where the match was found.
//          Large integer = FALSE if no match found.
//...............................................................
__int64 SearchFileBinaryInMemory(LPBYTE lpFileName, LPBYTE lpSearchString,
							     DWORD dwSizeOfString, HANDLE hFile,
								 DWORD dwHeaderBytes, LPSEARCH_TEMPLATE lpSearchParameters,
								 DWORD dwFileSize, DWORD dwRecordCount, LPBYTE lpTable);

// Perform a binary search on a structured table of data in memory
// to find the first match for the search string.
//
// Returns: LowPart = TRUE if a match is found and Highpart =
//          position in file where the match was found.
//          Large integer = FALSE if no match found.
//.................................................................
__int64 SearchTableBinaryInMemory(LPBYTE lpSearchString, DWORD dwSizeOfString, LPBYTE lpTable,
								  LPSEARCH_TEMPLATE lpSearchParameters, DWORD dwRecordCount);

// Perform comprehensive checks on the public and secret key rings.
//.................................................................
BOOL CheckOutTheKeyRings(BOOL bProcessRunning, HWND hParentWindow);

// CALLBACK procedure for the Check Key Rings dialog box.
//.......................................................
LRESULT CALLBACK CheckKeyRingsProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for the AskCheckKeyRings dialog box.
//......................................................
LRESULT CALLBACK AskCheckKeyRings(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Empty the message que so we make sure we process all
// messages before we continue.
//.....................................................
VOID EmptyTheMessageQue();

// Check the secret key ring. Returns FALSE if error.
//...................................................
BOOL CheckTheSecretKeyRing();

// Check the public key ring. Returns FALSE if error.
//...................................................
BOOL CheckThePublicKeyRing();

// The check/edit dialog displays a dialog box with error information
// about processing of a key on a key ring.
//...................................................................
VOID CheckEditError(UINT Title, LPBYTE lpUserId, LPBYTE lpSignatureId,
					UINT ErrorCode, UINT ActionCode, UINT Style, UINT Beep, LPCTSTR lpIcon);

// Mark the key in key buffer 1 for deletion or undeletion
// and write the result to disk. Returns FALSE if error.
//........................................................
BOOL MarkKey1(DWORD dwOperation);

// CALLBACK procedure for the enter current pass phrase dialog box.
//.................................................................
LRESULT CALLBACK GetCurrentPassPhraseProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Mark a packet, and its following trust packet, if any, for deletion.
//.....................................................................
VOID MarkPacket1();

// Set or edit the owner trust byte on a public key. We do not
// set or edit buckstop keys.
//
// Entry: Public key in lpKeyBuffer1.
//
// Exit: Returns FALSE if error.
//............................................................
BOOL SetTheOwnerTrustByte(DWORD dwOperation);

// CALLBACK procedure for the set owner trust dialog box.
//.......................................................
LRESULT CALLBACK SetTheOwnerTrustProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Initialize the trust table for computing trust.
//................................................
VOID InitializeTrustTable();

// Register the window class to use for viewing key rings.
//........................................................
BOOL RegisterViewWindow();

// Register the window class to use for editing key rings.
//........................................................
BOOL RegisterEditWindow();

// Window procedure for processing messages for view key ring window.
//...................................................................
LRESULT CALLBACK ViewWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// Window procedure for processing messages for edit key ring window.
//...................................................................
LRESULT CALLBACK EditWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// Register a window under Windows 95 or greater.
//...............................................
BOOL RegisterWin95(CONST WNDCLASS* lpwc);

// Setup the key we have selected to view.
//........................................
BOOL SetupKeyToView(HWND hWnd);

// Change the input to hex values.
//................................
VOID ChangeToHex(DWORD dwCount, LPBYTE lpSource, LPBYTE lpDestination, DWORD dwDirection);

// Given the Julian Day Number return the day of the week.
// 0 = Sunday, 1 = Monday, etc.
WORD DayOfWeek(DWORD dwJulianDay);

// Convert a timestamp to its proper GMT date and time.
//.....................................................
VOID TimestampToDateTime(__int64 Timestamp, LPSYSTEMTIME lpst);

// Calculate the fingerprint for a key which is composed of Modulus n
// and exponent e.
//...................................................................
VOID FingerPrint(LPBYTE lpModulusN, LPBYTE lpWorkBuffer, BOOL bMd5);

// Convert a byte, word, or dword to hexadecimal ascii characters
// and place them in the designated buffer.
//...............................................................
LPBYTE DisplayHex(DWORD dwValue, DWORD dwCharacters,LPBYTE lpDestination);

// Format the bits in a MPI for display.
//......................................
VOID FormatBits(DWORD dwBits);

// Transfer a MPI, a multiprecision number, in hex.
//.................................................
// Entry: lpKeyBufferDup1 points to the MPI. First
//        two bytes contains the bit count. 
//        iTotalLines points to the first line to
//        transfer the MPI to. Default source
//        direction = FORWARD and skip lines = 1.
//
// Exit:  lpKeyBufferDup1 points to the next MPI
//        or CTB.
//.................................................
LPBYTE TransferMPI(LPBYTE lpSource, DWORD dwSourceDirection, DWORD dwSkipLines);

// Check and make sure we do not have to many lines.
//..................................................
BOOL CheckLines();

// Build a central directory of keys and/or signatures to display
// for selecting for editing. 
//...............................................................
BOOL BuildCentralDirectory(LPCD_STRUCT lpCentralDirectory, BOOL bEdit);

// Edit a key ring.
//.................
VOID EditTheKeyRing();

// Get the major and minor version number of comctl32.dll.
//........................................................
BOOL GetComCtlVersion(LPDWORD lpdwMajor, LPDWORD lpdwMinor);

// Create the virtual list view window for our edit procedures.
//.............................................................
HWND CreateEditListView(HWND hWndParent);

// Resize the virtual list view window for the edit procedures.
//.............................................................
VOID ResizeEditListView(HWND hWndListView, HWND hWndParent);

// Handle the WM_NOTIFY message for the virtual list view window
// in our edit key ring procedures.
//..............................................................
LRESULT EditListViewNotify(HWND hWnd, LPNMHDR lpNmhdr);

// Mark the keys we want to perform an operation on or with.
// Returns FALSE if there is an error.
//..........................................................
BOOL MarkTheKeys();

// A table of the edit functions for key rings.
// They all return FALSE for cancel or errors.
//.............................................
BOOL AddUserId();
BOOL ChangePassPhrase();
BOOL DeleteKeys();
BOOL ExtractKeys();
BOOL IssueCompromiseCertificate();
BOOL SetOwnerTrust();
BOOL DeleteSignatures();
BOOL SignAPublicKey();
BOOL DisableAKey();

// Setup p, q, d, u, and n bytes for use by the SignMyKey
// procedures. Returns -1 for system error, 0 for no
// no password, and 1 for success.
//.......................................................
int SignSetup(LPBYTE lpSecretKeyBuffer, UINT uiPassPhraseMsg, UINT uiInvalidPP);

// CALLBACK procedure for the select type of signature dialog box.
//................................................................
LRESULT CALLBACK GetSignatureTypeProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for the signature calculatios dialog box.
//.............................................................
LRESULT CALLBACK SignatureCalcsProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Add a new user id to a pair of secret and public keys.
//.......................................................
LRESULT CALLBACK AddNewUserIdProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for the enter a new pass phrase dialog box.
//...............................................................
LRESULT CALLBACK GetNewPassPhraseProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Add keys to a key ring.
//........................
VOID AddKeysToAKeyRing();

// Check out a CTB to make sure it is a valid one for adding
// to a key ring. Returns TRUE if valid, else FALSE.
//..........................................................
BOOL IsValidCTB(BYTE KeyType, BYTE CTBByte);

// Find the start of the next key and in the process determine
// the length of this one. Returns 0 if error in key format,
// or else it returns the length of the key. Start of key in
// lpKeyBuffer3.
//............................................................
DWORD FindTheNextKey();

// Dialog box to display while adding keys to a key ring.
//.......................................................
LRESULT CALLBACK AddKeysToKeyRingProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// MergeTheKeys checks to see if two keys with the same key id
// are different and if so, merges the information from the two
// keys into one key and adds it to the key ring. The original
// key is then marked for deletion.
//
// Entry: Key from key ring in lpKeyBuffer1.
//        Key from source file in lpKeyBuffer3.
//        Merge the keys into lpKeyBuffer4.
//
// Returns: FALSE if unrecoverable error.
//          If the two keys are different mark the original
//          for deletion, and write the new merged key to
//          the end of the key ring. If they are the same
//          we skip this key and return.
//.............................................................
BOOL MergeTheKeys();

// Search an area of memory for a designated string.
// Returns TRUE if a match is found, else FALSE.
//..................................................
BOOL SearchFor(LPBYTE lpString, DWORD dwStringLength, LPBYTE lpWhere, DWORD dwMaximumLength);

// MergeSignatures merges signatures for identical user ids from the
// source file and the old key ring.
//
// Entry: lpKeyBufferDup3 points to the next packet in the 
//        source file. Most likely a trust packet following the
//        user id, or the end of the key.
//
//        lpN1Ptr points tot he first signature after the user id in
//        the old key ring, or the next user id, or the end of the key.
//
//        lpNextUserId points to the next user id in the old key ring
//        or the end of the key. If the pointers for lpN1Ptr and 
//        lpNextUserId are the same, no signatures in the old key
//        ring.
//
// Exit:  lpKeyBufferDup3 points to the next user id in the key or
//        the end of the key.
//.....................................................................
VOID MergeSignatures();

// Delete or wipe one or more files.
//..................................
VOID DeleteWipeFiles(LPBYTE lpBuffer, LPOPENFILENAME lpofn);

// Get options for Top Secret Crypto.
//...................................
VOID GetOptions();

// CALLBACK procedure for the Get the Options dialog box.
//.......................................................
LRESULT CALLBACK GetTheOptionsProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Update the registry entries with their new or initial values.
//..............................................................
VOID UpdateTheRegistry();

// Display the TSC logo.
//......................
VOID DisplayTscLogo();

// CALLBACK procedure for the Wipe/Delete dialog box.
//...................................................
LRESULT CALLBACK WipeDeleteProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Get the file attributes for a specified file.
//..............................................
DWORD GetMyFileAttributes(LPBYTE lpFileName);

// Set the file attributes for a specified file.
//..............................................
BOOL SetMyFileAttributes(LPBYTE lpFileName, DWORD dwAttributes);

// Perform a government wipe on a file. 
// Return FALSE if we have an error.
//.....................................
BOOL GovernmentWipe(LPBYTE lpFileName);

// Perform a wipe on a file on a compressed drive.
// Return FALSE if we have an error.
//................................................
BOOL CompressedWipe(LPBYTE lpFileName);

// Overwrite the contents of a file using the
// government wipe procedure. Returns FALSE
// if we have an error.
//...........................................
BOOL GovernmentOverWrite(LPBYTE lpFileName, HANDLE hFile, __int64 liFileSize, LPBYTE lpBuffer);

// Overwrite the contents of a file using the
// compressed wipe procedure. Returns FALSE
// if we have an error.
//...........................................
BOOL CompressedOverWrite(LPBYTE lpFileName, HANDLE hFile, __int64 liFileSize, LPBYTE lpBuffer);

// Backup one or more files.
//..........................
VOID BackupFiles(DWORD dwTypeOfCheck);

// Browse callback function for selecting a directory.
//....................................................
int CALLBACK BrowseCallbackProc(HWND hWnd, UINT uMsg, LPARAM lParam, LPARAM lpData);

// CALLBACK procedure for the backup files dialog box.
//....................................................
LRESULT CALLBACK BackupFilesProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for the ask if we want to overwrite dialog box.
//...................................................................
LRESULT CALLBACK AskOverwriteProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Retrieves an icon associated with a file.
// It it can't find one return null.
//..........................................
HICON FindMyIcon(LPBYTE lpFileSpec, LPBYTE lpFileExt);

// CALLBACK procedure for asking confirmation on wiping or
// deleting the file.
//........................................................
LRESULT CALLBACK ConfirmWipeDeleteProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Create one or more one time pad key files.
//...........................................
VOID CreateOneTimePads();

// CALLBACK procedure for asking how many otp key files we
// want to make.
//........................................................
LRESULT CALLBACK HowManyOtpKeyFilesProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for creating otp key files dialog box.
//..........................................................
LRESULT CALLBACK CreateOtpFilesProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Register the window class to use for viewing otp key files.
//............................................................
BOOL RegisterOtpViewWindow();

// Window procedure for processing message for view otp file window.
//..................................................................
LRESULT CALLBACK ViewOtpProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// View otp key files.
//....................
VOID ViewOneTimePadFiles();

// Setup an otp key file to view.
//...............................
VOID SetupOtpKeyFileToView();

// Test a number for the proper length of 13 characters.
// If not, we have to move the number to the right by 2
// and pad it with 2 spaces.
//.....................................................
VOID CheckOutTheNumber(LPBYTE lpNumber);

// Encrypt a file.
//................
BOOL EncryptAFile(LPBYTE lpBuffer, LPOPENFILENAME lpofn);

// Clear all the math variables.
//..............................
VOID ClearMathVariables();

// Retrieve the current directory.
//................................
BOOL GetMyCurrentDir(DWORD dwBufferLength,LPTSTR lpszBuffer);

// Set the current directory.
//...........................
BOOL SetMyCurrentDir(LPTSTR lpszDirectory);

// Dialog box for asking what type of session key we want to use.
//...............................................................
LRESULT CALLBACK AskSessionKeyProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Calculate a Md5 message digest for a file.
//...........................................
BOOL FileMd5(LPBYTE lpMd5File, LPBYTE lpMd5ForFile, LPBYTE lpMd5Append, DWORD dwAppendLength);

// Conduct an Md5 program check on the exe file. Use to check if
// the file has been altered. Returns FALSE for os error or invalid
// Md5 check value. 
//.................................................................
BOOL Md5ExeFileCheck(LPBYTE lpExeFile);

// Dialog box for asking for special instruction to follow before
// a file is decrypted.								   
//...............................................................
LRESULT CALLBACK GetSpecialInstructionsProc(HWND hDlg, UINT uiMsg, WPARAM wParam, 
											LPARAM lParam);

// CALLBACK procedure for the file encryption dialog box.
//.......................................................
LRESULT CALLBACK EncryptAFileProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// ChangeBytes will either encipher or decipher the contents
// of the buffer.
//..........................................................
VOID ChangeBytes(LPBYTE lpChangeBuffer, DWORD dwBytesToChange);

// Decrypt a file.
//................
BOOL DecryptAFile(LPBYTE lpDecryptFile);

// Check out the selected file to make sure it is a valid tsc
// encrypted file. Returns -1 if not a valid tsc encrypted file,
// else the file position of the ctb byte for the cke packet
// which is used by the phi and chi tests.
//..............................................................
__int64 IsTscFileValid(LPBYTE lpFileName);

// CALLBACK procedure for the decrypt pke packet dialog box.
//..........................................................
LRESULT CALLBACK DecryptPkePacketProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for the file decryption dialog box.
//.......................................................
LRESULT CALLBACK DecryptAFileProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for asking confirmation on overwriting
// the file with the one we are about to decrypt.
//........................................................
LRESULT CALLBACK ConfirmOverWriteDecProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Red Alert procedure.
//.....................
VOID RedAlert();

// Conduct a Phi test on an encrypted file.
//.........................................
VOID PhiTest(DWORD dwTypeFile);

// Conduct a Chi test on two encrypted files.
//...........................................
VOID ChiTest();

// Setup the Phi View Window for displaying the Phi data.
//.......................................................
VOID SetupPhiViewWindow();

// Setup the Chi View Window for displaying the Chi data.
//.......................................................
VOID SetupChiViewWindow();

// Register the window class to use for viewing Phi data on
// encrypted files.
//.........................................................
BOOL RegisterPhiWindow();

// Window procedure for processing messages for Phi and Chi Tests.
//................................................................
LRESULT CALLBACK PhiProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for accumulating phi data.
//..............................................
LRESULT CALLBACK GetPhiDataProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for accumulating chi data.
//..............................................
LRESULT CALLBACK GetChiDataProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Quad precision multiply procedure.
// Entry: Argument 1 in qa1 and argument 2 in qa2.
// 
// Exit: Quad result in qr1.
//...................................
VOID QuadMultiply();

// Perform a quad precision division procedure.
// Entry: Dividend in qr1.
//        Divisor in qa1.
//
// Exit:  Quotient in qa1.
//        Remainder in qa2.
//.............................................
VOID QuadDivide();

// View the contents of a tsc encrypted file.
//...........................................
VOID ViewTscFile();

// Setup the senders and recipients of an encrypted file.
//.......................................................
BOOL SetupSendersRecipients();

// Register the window class to use for viewing the senders
// and recipients of a tsc encrypted file.
//..........................................................
BOOL RegisterSendersWindow();

// Window procedure for processing the view senders and
// recipients messages.
//......................................................
LRESULT CALLBACK SendersProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// Register the window class for viewing the contents of a
// tsc encrypted file.
//........................................................
BOOL RegisterTscWindow();

// Window procedure for viewing the contents of a tsc encrypted
// file.
//...............................................................
LRESULT CALLBACK TscWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// Handle the WM_NOTIFY message for the virtual list view window
// while viewing the contents of a tsc encrypted file.
//..............................................................
LRESULT EditTscViewNotify(HWND hWnd, LPNMHDR lpNmhdr);

// Create the virtual list view window for viwing our tsc encrypted
// file.
//.................................................................
HWND CreateTscListView(HWND hWndParent);

// Resize the virtual list view window for the edit procedures.
//.............................................................
VOID ResizeTscListView(HWND hWndListView, HWND hWndParent);

// Check to see if default value is set to the correct value.
// If not, we may have an illegal copy.
//...........................................................
CheckTheRegistry();

// Transform a a file for e-mail transmission.
//............................................
VOID TransformForEmail();

// Extract a transformed file.
//............................
VOID ExtractEmail();

// Reconstruct two or more transformed files.
//...........................................
VOID ReconstructEmail();

// CALLBACK procedure for setting the size of the files
// we will be breaking the original file into.
//.....................................................
LRESULT CALLBACK TransformSizeProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Build or delete the crc32 table.
//.................................
BOOL Crc32Table(DWORD dwStatus);

// CALLBACK procedure for creating the transfomed files for
// e-mail transmission.
//.........................................................
LRESULT CALLBACK TransformProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// StuffR64 converts 6 bits into a byte according to the
// translation table. Returns FALSE if i/o error.
//......................................................
BOOL StuffR64(LPBYTE lpFileName, HANDLE hFile, DWORD dwNextByte, DWORD dwFlag, 
			  BOOL bDoIntegrity);

// ConvertToR64 converts three bytes in the in buffer to 4 ascii
// bytes in the out buffer using the radix 64 method. Returns
// FALSE if i/o error.
//..............................................................
BOOL ConvertToR64(LPBYTE lpFileName, HANDLE hFile, DWORD dwByteCount, 
				  BOOL bCheckIntegrity);

// CALLBACK procedure for extracting transformed files from
// an e-mail file.
//.........................................................
LRESULT CALLBACK ExtractProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// ConvertR64ToBinary converts 4 bytes from the in buffer and 
// converts them to three binary bytes. Returns FALSE if i/o error.
//.................................................................
BOOL ConvertR64ToBinary(LPBYTE lpFileName, HANDLE hFile, DWORD dwByteCount,
						BOOL bCheckIntegrity);

// UnStuffR64 converts a byte value back to its original 6 bit value
// via the proper translation table. Returns FALSE if i/o error.
//..................................................................
BOOL UnStuffR64(LPBYTE lpFileName, HANDLE hFile, DWORD dwNextByte, 
			    DWORD dwFlag, BOOL bDoIntegrity);

// Setup the What's This popup menu.
//..................................
VOID SetupWhatsThis();

// What's This popup menu and popup help for dialog box controls.
//...............................................................
VOID WhatsThis(HWND hDlg, HWND hControl, LPARAM lParam);

// PopupHelp processes the WM_HELP messages for dialog boxes.
//...........................................................
VOID PopupHelp(HWND hDlg, LPARAM lParam);

// CALLBACK procedure for reconstructing the original file from
// one or more transformed files.
//.............................................................
LRESULT CALLBACK ReconstructProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Set the maximum code size that the procedures can use.
//.......................................................
VOID SetTheMaximumCodeSize();

// Set the maximum possible code size to use for compressing
// and decompressing on start up.
//..........................................................
VOID SetMaxCodeSizeOnStartUp();

// CALLBACK procedure for setting the maximum code size to use
// while packing a file.
//............................................................
LRESULT CALLBACK SetMaximumCodeSizeProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Pack one or more files.
//........................
BOOL PackFiles(LPBYTE lpBuffer, LPOPENFILENAME lpofn);

// Unpack a packed file.
//......................
BOOL UnpackAFile(LPBYTE lpPkdFile);

// Set up the parameters for the lzw compressor/decompressor.
//...........................................................
VOID SetLzwParameters(LPCODE_STATS lpCodeStats, int iIndex);

// CALLBACK procedure for packing files.
//......................................
LRESULT CALLBACK PackFilesProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Compress a file. Returns false for i/o errors.
//...............................................
BOOL CompressMyFile(LPBYTE lpOutFile, HANDLE hOutFile, LPBYTE lpInFile, HANDLE hInFile);

// The following procedure is for zipping a file.
// Returns FALSE for i/o errors.
//...............................................
BOOL ZipMyFile(LPBYTE lpOutFile, HANDLE hOutFile, LPBYTE lpInFile, HANDLE hInfile);

// Calculate a crc32 check value for a file header.
//.................................................
VOID CalculateHeaderCrc();

// InitializeTable sets up the code and hash tables.
//..................................................
VOID InitializeTables(DWORD dwStatus);

// StuffLzwCode puts a lzw code in the output buffer. Each code
// is 9 to 24 bits long. Returns FALSE for i/o error.
//.............................................................
BOOL StuffLzwCode(LPBYTE lpFile, HANDLE hFile, DWORD dwLzwCode, DWORD dwFlag);

// GetTheNextByte gets the next byte from the input buffer.
// If the buffer is empty it reads in more of the file. If
// end of file, it sets bEndOfFile to TRUE. Returns -1
// for i/o error or the next byte in LOBYTE(LOWORD).
//.........................................................
DWORD GetTheNextByte(LPBYTE lpFile, HANDLE hFile, DWORD dwFlag);

// GetLzwCode entered with the current character in dwChar
// and the old code in dwOldCode. Returns with lzw code or
// IN_TABLE indicating that the code alread exists in the
// table.
//.........................................................
DWORD GetLzwCode(DWORD dwChar);

// CALLBACK procedure for displaying the final packed file status.
//................................................................
LRESULT CALLBACK PackedFileStatusProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for unpacking files.
//........................................
LRESULT CALLBACK UnpackFilesProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Check the header crc32 value for a packed file.
//................................................
BOOL CheckHeaderCrc();

// CALLBACK procedure for the ask if we want to overwrite dialog box
// while unpacking a file.
//...................................................................
LRESULT CALLBACK AskOverwriteUnpackProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Main decompression procedures. Returns FALSE for i/o error.
// If hOutFile is 0, do not write any output to disk. Used for
// testing the integrity of the packed file.
//............................................................
BOOL DecompressTheFile(LPBYTE lpInFile, HANDLE hInFile, LPBYTE lpOutFile, HANDLE hOutFile);

// The following procedure is for unzipping the file.
// Returns FALSE for i/o errors.
//...................................................
BOOL UnzipMyFile(LPBYTE lpInFile, HANDLE hInFile, LPBYTE lpOutFile, HANDLE hOutFlie);

// GetTheCode gets bytes from the input buffer. Returns a 9 to 24
// lzw code. Returns -1 if i/o error.
//...............................................................
DWORD GetTheCode(LPBYTE lpInFile, HANDLE hInFile);

// GetOneByte gets one byte from the input buffer and places it in
// Temp. If the buffer is empty, it reads more into the input
// buffer. If eof it set bEndOfFile to true. Returns FALSE for
// i/o error.
//................................................................
BOOL GetOneByte(LPBYTE lpInFile, HANDLE hInFile);

// StuffCharacter stuffs a decompressed character onto the pseudo stack.
//......................................................................
VOID StuffCharacter(BYTE MyChar);

// UnStuffBuffer takes the characters off the pseudo stack in reverse
// order and places them in the output buffer. If the output buffer
// gets full it is written to disk. Calculates crc32 check value.
// Returns FALSE for i/o error.
//...................................................................
BOOL UnStuffBuffer(LPBYTE lpOutFile, HANDLE hOutFile);

// DoOutput writes the output buffer to disk. If the output handle
// is 0 just zero the output count. Used for testing the packed file.
// Returns FALSE for i/o error.
//...................................................................
BOOL DoOutput(LPBYTE lpOutFile, HANDLE hOutfile);

// Test a packed file for integrity.
//..................................
VOID TestAPackedFile();

// CALLBACK procedure for testing a packed file.
//..............................................
LRESULT CALLBACK TestPackedFileProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Freshen a packed file
//......................
VOID FreshenAPackedFile();

// CALLBACK procedure for freshening a packed file.
//.................................................
LRESULT CALLBACK FreshenPackedFileProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Add files to a packed file.
//............................
VOID AddFilesToAPackedFile();

// Build a central directory of the files in a packed file.
// Entry: Handle in hInputfile, name in szFileName, file
// header in pfidhdr. File pointer pointing to first file
// header.
//.........................................................
BOOL BuildPackedFileCentralDir(LPBYTE lpPackedFile, HANDLE hPackedFile);

// CALLBACK procedure for adding files to a packed file.
//......................................................
LRESULT CALLBACK AddToAPackedFileProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// View the contents of a packed file.
//....................................
VOID ViewAPackedFile();

// Register the window class for viewing the contents of a
// packed file.
//........................................................
BOOL RegisterPackedWindow();

// Window procedure for viewing the contents of a packed file.
//............................................................
LRESULT CALLBACK PackedWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// Handle the WM_NOTIFY message for the virtual list view window
// while viewing the contents of a packed file.
//..............................................................
LRESULT EditPackedViewNotify(HWND hWnd, LPNMHDR lpNmhdr);

// Create the virtual list view window for viwing our packed file.
//................................................................
HWND CreatePackedListView(HWND hWndParent);

// Resize the virtual list view window for the edit procedures.
//.............................................................
VOID ResizePackedListView(HWND hWndListView, HWND hWndParent);

// Procedure for selecting the files to extract or delete from
// a packed file. If bExtract is TRUE we extract files from a
// packed file. If bExtract is FALSE we delete files from a
// packed file.
//............................................................
VOID PackedFileProc();

// CALLBACK procedure for deleting files from a packed file.
//..........................................................
LRESULT CALLBACK DeletePackedFilesProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for extracting files from a packed file.
//............................................................
LRESULT CALLBACK ExtractPackedFilesProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Check to see if the program is properly registered.
//....................................................
BOOL CheckRegistration();

// Display the registration reminder screen where one can
// enter the required information.
//.......................................................
BOOL RegistrationReminder();

// CALLBACK procedure for entering registratin information.
//.........................................................
LRESULT CALLBACK RegisterProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Calculate what the correct registration number should be.
// Returns TRUE if there is match.
//..........................................................
BOOL CalculateRegistrationNumber();

// CALLBACK procedure for asking confirmation on overwriting
// the file with the one we are about to transform.
//........................................................
LRESULT CALLBACK ConfirmOverWriteXformProc(HWND hDlg, UINT uiMsg, WPARAM wParam,
										   LPARAM lParam);

// View the public key ring.
//..........................
VOID ViewPublicKeyRing();

// View the secret key ring.
//..........................
VOID ViewSecretKeyRing();

// Reset the programs priority to normal if it is not normal.
//...........................................................
VOID ResetProgramPriority();

// Determine the platform we are running on.
//..........................................
BOOL GetPlatform();

// Notify me sound function.
//..........................
VOID NotifyMe();

// Format a file name or string for displaying in an edit box. Look
// for & and make them double.
//.................................................................
VOID SetDlgItemTextFmt(HWND hDlg, int iControlID, LPCTSTR lpFileName);

// Display the Elapsed Timer with a zero value.
//.............................................
VOID DisplayZeroTimer();

// Setup the key ring file names for the status bar.
//..................................................
VOID KeyRingsForStatusBar();

// Get the address of the display name for a file. Will return a name
// based on the global windows setting for showing known file extensions.
//.......................................................................
LPVOID GetDisplayName(LPSHFILEINFO pshfi, LPCTSTR lpszPath);

// Backup the loaded set of key rings.
// Returns true if we have a disk errro.
//......................................
BOOL BackupKeyRings(LPBYTE lpBuffer);

// Get the encrypted registration data.
//.....................................
BOOL GetTheEncryptedData();

// Make a true one time pad file.
//...............................
VOID MakeATrueOneTimePad();

// CALLBACK procedure for asking how large a true one time pad file we
// want to make.
//....................................................................
LRESULT CALLBACK TrueOneTimePadFileSizeProc(HWND hDlg, UINT uiMsg, WPARAM wParam,
											LPARAM lParam);

// CALLBACK procedure for creating a true one time pad.
//.....................................................
LRESULT CALLBACK CreateTrueOneTimePadProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// View a true one time pad in a virtual list window.
//...................................................
VOID ViewTrueOneTimePad();

// Check for a valid True One Time Pad File.
//..........................................
HANDLE IsValidTruePadFile(LPTSTR lpFileName);

// Window procedure for viewing the contents of a true time time pad file.
//........................................................................
LRESULT CALLBACK TOTPWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// Register the window class for viewing the contents of a
// true one time pad file.
//........................................................
BOOL RegisterTOTPWindow();

// Handle the WM_NOTIFY message for the virtual list view window
// while viewing the contents of a true one time pad file.
//..............................................................
LRESULT TOTPViewNotify(HWND hWnd, LPNMHDR lpNmhdr);

// Create the virtual list view window for viwing our true one time pad file.
//...........................................................................
HWND CreateTOTPListView(HWND hWndParent);

// Resize the virtual list view window for the edit procedures.
//.............................................................
VOID ResizeTOTPListView(HWND hWndListView, HWND hWndParent);

// Check to see if we can use the timestamp counter.
//..................................................
BOOL CheckTimeStampCounter();

// ChangeBytesPad will either encipher or decipher the contents
// of the buffer.
//.............................................................
BOOL ChangeBytesPad(LPBYTE lpChangeBuffer, DWORD dwBytesToChange, HANDLE hFile);

// Wipe a section of a pad file that we used.
//...........................................
BOOL WipePadSection(LPTSTR FileName, HANDLE hFile, __int64 StartPosition, __int64 Lenth);

// Pad Overwrite procedure.
//.........................
BOOL PadOverWrite(LPTSTR FileName, HANDLE hFile, __int64 StartPosition,
				  __int64 Length, LPBYTE lpBuffer);

// Send file as an e-mail attachment.
//...................................
VOID SendFileAsAttachment();

// Export a Public Key to the clipboard.
//......................................
BOOL ExportPublicKey();

BOOL PublicKeyToClipboard(LPBYTE lpKeyBuffer);

// Initialize the crc table.
//..........................
VOID Crc24Init(LPDWORD Table);

// Update a CRC to reflect the addition of some more bytes.
//.........................................................
DWORD Crc24Update(DWORD crc, LPBYTE Buffer, DWORD len);

// Armor 3 raw bytes into 4
// If armoring n < 3 bytes, make the trailers zero, and
// then overwrite the trailing 3-n bytes with '='
//.....................................................
VOID ArmorMorsel(LPBYTE Raw, LPBYTE Armor);

// Armor one line of 48 or less characters.
//.........................................
DWORD ArmorLine(LPBYTE lpin, DWORD dwinlen, LPBYTE lpout);

// Armor a buffer of data.
//........................
LPBYTE ArmorBuffer(LPBYTE lpInBuffer, LPBYTE lpOutBuffer, DWORD dwLength);

// Import a public key from the clipboard to the public key ring.
//...............................................................
VOID ImportAPublicKey();

// Dearmor a buffer.
//..................
LPBYTE DearmorBuffer(LPBYTE lpInBuffer,LPBYTE lpOutBuffer, LPDWORD lpOutLength);

// Get the crc24 value from the buffer.
//.....................................
DWORD GetCrc24(LPBYTE lpInBuff);

// Encrypt the contents of the clipboard.
//.......................................
VOID EncryptTheClipboard();

// Decrypt the contents of the clipboard.
//.......................................
VOID DecryptTheClipboard();

// Select the type of clipboard format to encrypt.
//................................................
LRESULT CALLBACK SelectClipboardFormatProc(HWND hDlg, UINT uiMsg, WPARAM wParam, 
										   LPARAM lParam);

// Get the registered clipboard format numbers.
//.............................................
VOID GetClipboardFormatNumbers();

// Deinitialize the MAPI Library.
//...............................
VOID DeInitializeMAPI();

// Initialize the MAPI library and get the procedure addresses.
//.............................................................
int InitializeMAPI();

// Find and decrypt any e-mail files.
//...................................
VOID FindAndDecryptEmail();

// Register a rich text parent window.
//....................................
BOOL RegisterMyRtfWindow();

// Create the rich text window.
//.............................
HWND CreateRtfWindow(HWND hWndParent);

// Resize the rich text window.
//.............................
VOID ResizeRtfWindow(HWND hWndRtf, HWND hWndParent);

// Window procedure for viewing a rich edit window.
//.................................................
LRESULT CALLBACK RtfWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// Callback function for streaming the data into the rich text window.
//....................................................................
DWORD CALLBACK EditStreamInCallback(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG FAR *pcb);

// Logon to a MAPI mail session.
//..............................
BOOL LogonToMapi(DWORD dwHelp, BOOL bShowMsg, BOOL bHangup);

// Logoff from a MAPI mail session.
//.................................
VOID LogoffFromMapi(BOOL bShowMsg, BOOL	bHangup);

// Popup the Address Book.
//........................
VOID GetTheAddressBook();

// Turn off all the MAPI commands.
//................................
VOID TurnOffMAPI();

// Compose a regular e-mail message.
//..................................
VOID ComposeRegularMail();

// Memory manager function prototypes.
//....................................
LPBYTE PvAlloc(ULONG cbSize);

LPBYTE PvAllocMore(ULONG cbSize, LPBYTE lpvParent);

BOOL PvFree(LPBYTE lpv);

// Compose and encrypt e-mail in rich text format.
//................................................
VOID EncryptMail();

// CALLBACK procedure for the Compose, Encrypt, and Send dialog box.
//..................................................................
LRESULT CALLBACK ComposeNoteProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Finds recipients of a given class and adds their friendly names
// to the display string.
//................................................................
BOOL MakeDisplayNameStr(HWND hWnd, LPTSTR lpszDisplay, ULONG ulRecipClass,
						ULONG cRecips, lpMapiRecipDesc lpRecips);

// Helper function to convert a string of ';' delimited friendly
// names into an array of MapiRecipDescs.
//..............................................................
ULONG ResolveFriendlyNames(HWND hWnd, LPSTR lpszDisplayNames, ULONG ulRecipClass,
						   ULONG * lpcRecips, lpMapiRecipDesc * lppRecips);

// Called in support of ResolveFriendlyNames() to build an array
// of chained MapiRecipDescs.
//..............................................................
ULONG CopyRecipient(lpMapiRecipDesc lpParent, lpMapiRecipDesc lpDest, lpMapiRecipDesc lpSrc);

// To find lpszName in an array of recipients. Used to determine
// if user name has already been resolved.
//...............................................................
BOOL FNameInList(LPSTR lpszName, ULONG cRecips, lpMapiRecipDesc lpRecips);

// Setup the rtf context menu.
//............................
VOID SetupRtfContextMenu();

// Popup menu for the rtf control.
//................................
VOID RtfContextMenu(HWND hDlg, HWND hControl, LPARAM lParam, int iIDControl);

// Get the total number of characters in the richedit control.
//............................................................
DWORD GetTheTotalCharacters(HWND hRtf);

// Select a character font for the richedit text control.
//.......................................................
VOID SelectCharFormat(HWND hDlg, HWND hControl, LPBYTE lpFont);

// Update the radio buttons depending on the situation.
//.....................................................
VOID UpdateRtfRadioButtons(HWND hDlg, UINT uIdRtf);

// Hook procedure for selecting a font.
//.....................................
UINT CALLBACK MyCFHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Hook procedure for selecting colors.
//.....................................
UINT CALLBACK MyCCHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Open a file for streaming into a rich edit text control.
//.........................................................
BOOL OpenFileStreamIn(LPTSTR lpFileName, HWND hDlg, int iIDRtf, int iAttrib);

// Callback function for streaming the data out of a rich text window.
//....................................................................
DWORD CALLBACK EditStreamOutCallback(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG FAR *pcb);

// Create a file for streaming rich text out of a rtf control.
//............................................................
BOOL CreateFileStreamOut(LPTSTR lpFileName, HWND hDlg, int iIDRtf, UINT uFormat, 
						 BOOL bDefault);

// Get file attachments for an e-mail message
//...........................................
ULONG GetNextFile(HWND hWnd, ULONG nPos, ULONG * lpcAttach, lpMapiFileDesc * lppAttach);

// Copy the old files to an new file structure.
//.............................................
ULONG CopyAttachment(lpMapiFileDesc lpParent, lpMapiFileDesc lpDest, lpMapiFileDesc lpSrc);

// Read, decrypt, and save e-mail messages.
//.........................................
VOID DecryptMail();

// CALLBACK procedure for displaying the contents of the inbox.
//.............................................................
LRESULT CALLBACK InBoxProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Build a central directory of all the messages.
//...............................................
BOOL BuildMsgCentralDir();

// Delete the fields in the message list for each message.
//........................................................
DeleteMsgListItems();

// Handle the WM_NOTIFY message for the virtual list view window
// while viewing the contents of our inbox.
//..............................................................
LRESULT MsgListNotify(HWND hDlg, LPNMHDR lpNmhdr);

// Delete selected messages.
//..........................
VOID DeleteMsgs();

// CALLBACK procedure for reading the contents of a message.
//..........................................................
LRESULT CALLBACK ReadMessageProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Save the file attachments on an e-mail message.
//................................................
VOID SaveFileAttachments(HWND hWnd);

// Decrypt the message in lpReadMsg. Place the decrypted
// contents in the rich text edit control.
//......................................................
BOOL DecryptTheMessage(HWND hDlg);

// Creat a new message to reply to an old message.
//................................................
BOOL MakeNewMessage (lpMapiMessage lpSrcMsg, UINT flType);

//Encrypt an e-mail message.
//..........................
BOOL EncryptAnEmailMessage();

// Center small modeless dialog boxes.
//....................................
LRESULT CALLBACK CenterDlgBoxProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Handle a return receipt request.
//.................................
VOID HandleReturnReciept(HWND hWnd);

// Wipe one file.
//...............
BOOL WipeMyFile(LPBYTE lpFileToWipe, BOOL bDlgBox);

// Popup menu for the read message rtf control.
//.............................................
VOID ReadContextMenu(HWND hDlg,HWND hControl, LPARAM lParam);

// Save a message in a rtf box as a file.
//.......................................
VOID SaveMsgAs(HWND hDlg, int iIDRtf);

// Set zeros to ones, and ones to zeros.
//......................................
VOID SetCustomColors(BOOL bSetToOnes);

// Save the directory name so the next time you open or save a file
// you can return to this directory.
//.................................................................
VOID SaveDirName(LPBYTE lpDirName,	DWORD dwDestination, BOOL bRemoveFileName);

// Print the contents of a rich text edit control.
//................................................
VOID PrintRTF(HWND hDlg, HWND hRTF, int iIDRTF, int iIDSubj);

// Set miscellaneous current user registry entries.
//.................................................
VOID SetCurrentUserRegistryEntries(HKEY hKey);

// Setup a table of toolbar definitions.
//......................................
int SetupToolbarTable();

// Get the current toolbar configuration.
//.......................................
VOID GetToolbarConfiguration();

// Set the contents of the clipboard to the passed text data.
//...........................................................
VOID SetMyClipboard(LPBYTE lpData);

// CALLBACK procedure for the Ask About MAPI dialog box.
//......................................................
LRESULT CALLBACK AskAboutMAPIProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Bypass check for exe file MD5 security check.
//..............................................
BOOL BPC();

// Prototypes for the SHA context procedures.
//...........................................
VOID ShaUpdate(LPSHACONTEXT lpShactx, LPBYTE bufIn, DWORD len);
VOID ShaByteSwap(LPDWORD dest, LPBYTE src, DWORD words);
VOID ShaInit(LPSHACONTEXT lpShactx);
VOID ShaTransform(LPDWORD block, LPDWORD key);
VOID ShaFinal(LPBYTE lpshaDigest, LPSHACONTEXT lpShactx);

// Calculate a SHA digest for a file.
//...................................
BOOL FileSha(LPBYTE lpShaFile, LPBYTE lpShaForFile, LPBYTE lpShaAppend, DWORD dwAppendLength);

// Special hook for open file dialog for encrypting a file.
// Adds a wipe after encryption checkbox.
//.........................................................
UINT CALLBACK MyEncOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Special hook for open file dialog for packing files.
// Adds a wipe after packing checkbox.
//.....................................................
UINT CALLBACK MyPackOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Wipe a file after it has been encrypted.
//.........................................
BOOL ConfirmWipeMyFile(UINT uAsk, LPBYTE lpFileToWipe, BOOL bDlgBox);

// Special hook for open file dialog for decrypting a file.
// Adds a wipe after decryption checkbox.
//.........................................................
UINT CALLBACK MyDecOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam,LPARAM lParam);

// Special hook for open file dialog for One Time Pad Key File.
// Adds a wipe after use check box.
//.............................................................
UINT CALLBACK MyOTPOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Special hook for open file dialog for True One Time Pad File.
// Adds a wipe after use check box.
//..............................................................
UINT CALLBACK MyTrueOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Special hook for open file dialog for unpacking a file.
// Adds a wipe after unpacking checkbox.
//........................................................
UINT CALLBACK MyUnpackOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Special hook for open file dialog for transforming a file.
// Adds a wipe after transformation checkbox.
//...........................................................
UINT CALLBACK MyXformOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Special hook for open file dialog for extracting a transformed file.
// Adds a wipe after extraction checkbox.
//.....................................................................
UINT CALLBACK MyExtrOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Move the random bits bin file.
//...............................
VOID MoveTheRBBFile();

// Calculate what the correct registration number should be.
// Returns true is there is a match.
//..........................................................
BOOL CalculateRegistrationNumberSha();

// Check out the administrator account and set the final status
// of the menu items.
//.............................................................
DWORD CheckAdminAccount();

// Update the admin and trial period registry entries.
//....................................................
VOID UpdateAdmin();

// Check to see if we have a valid packed file. If we do, return the handle.
//..........................................................................
HANDLE IsValidPackedFile(LPBYTE lpFileName, BOOL bShowError);

// Check to see if a file is already compressed.
//..............................................
BOOL IsFileAlreadyPacked(LPBYTE lpFile);

// Special hook for open file dialog box for attaching files to an e-mail message.
// Adds a compress and encrypt and wipe check boxes.
//................................................................................
UINT CALLBACK MyAttachOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Context menu for file attachments.
//...................................
VOID AttachContextMenu(HWND hDlg,HWND hControl, LPARAM lParam);

// Create an Administrator Account.
//.................................
VOID CreateAdminAccount();

// CALLBACK procedure for create Administator Account dialog box.
//...............................................................
LRESULT CALLBACK CreateAdminProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Clear the admin entries.
//.........................
VOID ClearAdminEntries(HWND hDlg);

// Setup the Admin menu.
//......................
VOID SetAdminMenu(BOOL bCreateOnly);

// Sign in to the admin account.
//..............................
BOOL AdminSignIn(BOOL bShowMsg);

// Sign out of the admin account.
//...............................
VOID AdminSignOut();

// CALLBACK procedure for signing into your Administator Account dialog box.
//..........................................................................
LRESULT CALLBACK SignInAdminProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Delete the admin account.
//..........................
VOID DeleteAdminAccount();

// Change admin account information.
//..................................
VOID ChangeAdminAccount();

// CALLBACK procedure for change Administator Account dialog box.
//...............................................................
LRESULT CALLBACK ChangeAdminProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Set the universal public key to use.
//.....................................
BOOL SetUniversalKey();

// Change the administrator settings for this computer.
//.....................................................
VOID SetAdminSettings();

// CALLBACK procedure for the general admin settings dialog box.
//..............................................................
LRESULT CALLBACK AdminGeneralProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for admin public key ring settings dialog box.
//..................................................................
LRESULT CALLBACK AdminPublicKeyProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for admin secret key ring settins dialog box.
//.................................................................
LRESULT CALLBACK AdminSecretKeyProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Callback procedure for creating the property sheet and
// getting its HWND.
//........................................................
int CALLBACK PropertySheetProc(HWND hDlg, UINT uiMsg, LPARAM lParam);

// Default message for needing a universal key before you can encipher anything.
//..............................................................................
BOOL WeHaveAUniversalKey();

// This procedure checks to see if we are authorized to run it.
//.............................................................
BOOL ProcedureAuthorized(DWORD dwPermitCode);

// E-mail support request.
//........................
VOID EmailSupportRequest();

// Determines the zlib error and displays the error procedure message box.
//........................................................................
VOID ZlibError(LPBYTE lpFile, int iError, DWORD dwProcedure);

// Set or change a password required to run the program.
//......................................................
VOID SetMyPassword();

// Check on the password. If one is not set, ask if we want to set one.
// If one is set, get it and see if it is correct. Return TRUE if there
// is an error.
//.....................................................................
BOOL CheckPassword();

// CALLBACK procedure for checking on your password.
//..................................................
LRESULT CALLBACK AskPasswordProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for setting your password.
//..............................................
LRESULT CALLBACK SetPasswordProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for signing into tscg.
//..........................................
LRESULT CALLBACK SignInPasswordProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Center small modeless dialog boxes.
//....................................
LRESULT CALLBACK CenterWipeDlgBoxProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Folder operations.
//...................
VOID FolderOps(DWORD dwOps);

// Popup the virtual keyboard.
//............................
VOID VirtualKeyboard(HWND hDlg,int iEditBox, LPBYTE lppw, DWORD dwPwLength);

// CALLBACK procedure for the virtual keyboard dialog box.
//........................................................
LRESULT CALLBACK VirtualKeysProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Set the computers time from the Internet.
//..........................................
VOID SetTimeFromInternet();

// Conduct an encrypted 2-way chat.
//.................................
VOID Chat();

// CALLBACK procedure for setting the time from the internet.
//...........................................................
LRESULT CALLBACK InternetTimeProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// EditPrintf: A printf function for edit boxes!
//..............................................
VOID EditPrintf(HWND hwndEdit, TCHAR * szFormat, ...);

// Change the system time.
//........................
VOID ChangeSystemTime(HWND hDlg, HWND hWndEdit, ULONG ulTime);

// FormatUpdatedTime.
//...................
VOID FormatUpdatedTime(HWND hwndEdit, LPSYSTEMTIME pstOld, LPSYSTEMTIME pstNew);

// ConvertToAbsolute:  Converts day-in-month format to absolute date/time.
//........................................................................
VOID ConvertToAbsolute(LPSYSTEMTIME pstLoc, LPSYSTEMTIME pstDst, LPSYSTEMTIME pstDstAbs);

// LocalGreaterThanTransition: Returns TRUE if the local time comes 
// after the daylight saving time (or standard time) transition.
//.................................................................
BOOL LocalGreaterThanTransition(LPSYSTEMTIME pstLoc, LPSYSTEMTIME pstTran);

// MySystemTimeToTzSpecificLocalTime. Works on all platforms.
// UTC time and time-zone information go in; local time comes out.
//................................................................
BOOL MySystemTimeToTzSpecificLocalTime(LPTIME_ZONE_INFORMATION ptzi, 
                                       LPSYSTEMTIME pstUtc, LPSYSTEMTIME pstLoc);

// Hangup the phone.
//..................
BOOL HangUp(HWND hWnd);

// Dial an internet connection.
//.............................
BOOL DialInternet(HWND hWnd);

// Display an RAS error message box.
//..................................
VOID RasError(DWORD dwErr);

// Select bullet and bullet style.
//................................
LRESULT CALLBACK BulletsProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Format a paragraph in a rich edit control.
//...........................................
LRESULT CALLBACK FormatParagraphProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Select a date or time to insert into your message.
//...................................................
LRESULT CALLBACK DateTimePickerProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for asking confirmation on deleting email messages.
//.......................................................................
LRESULT CALLBACK ConfirmDeleteEmailProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for TSCG tips dialog box.
//.............................................
LRESULT CALLBACK TscgTipProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for encrypted chat.
//.......................................
LRESULT CALLBACK ChatProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Set the Chat key.
//..................
BOOL SetTheChatKey();

// Send a notification message with the ip address we are listening on.
//.....................................................................
VOID SendNotificationMsg();

// Save a chat session in a rtf box as a file.
//............................................
VOID SaveChatAs(HWND hDlg, int iIDRtf);

// CALLBACK procedure for setting the fonts and colors.
//.....................................................
LRESULT CALLBACK ChatPropertiesProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Select a character font for the send text in a chat rtf box.
//.............................................................
VOID SelectCharFormatChat(HWND hDlg, HWND hControl);

// Import a secret key from the clipboard to the secret key ring.
//...............................................................
VOID ImportASecretKey();

// View fingerprint and other information about a public key.
// Return FALSE for cancel or error.
//...........................................................
BOOL ViewKeyFingerprint();

// CALLBACK procedure for displaying key fingerprint information.
//...............................................................
LRESULT CALLBACK KeyFingerprintProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Get fingerprint material to display.
//.....................................
VOID GetFingerprint(HWND hDlg);

// Fill a line with words for the message digest.
//...............................................
VOID FillALine(DWORD dwArg, LPBYTE lpLine, DWORD dwLineSize);

// Check out the file to see if it has any new version packets
// or needs to be converted from V4 to V3 keys.
//............................................................
BOOL CheckOutTheFile();

// Sign a file with a detached signature. It may be sent to a file
// or the clipboard.
//................................................................
VOID SignAFile();

// Check a file's signatures. It may be in a file or the clipboard.
//.................................................................
VOID CheckFilesSig(LPBYTE lpSigFile);

// Special hook for open file dialog for signing a file.
//......................................................
UINT CALLBACK MySignOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for signing a file.
//.......................................
LRESULT CALLBACK SignAFileProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Special hook for open file dialog for checking a signature file.
//.................................................................
UINT CALLBACK MyCheckOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for displaying the final results of checking a file's signature.
//....................................................................................
LRESULT CALLBACK CheckFileProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Set a bold font for a dialog box control.
//..........................................
VOID SetBoldFont(HWND hDlg, DWORD dwControl, DWORD dwControl2);

// Set a bold font for a dialog box control.
//..........................................
VOID SetBoldFont2(HWND hDlg, DWORD dwControl);

// Sentry Spelling Checker Engine Error.
//......................................
BOOL SentrySpellError(SHORT sError);

// Check the entries for the spell checker for this user.
//.......................................................
BOOL CheckSSCERegistry();

// Create a new diary.
//....................
BOOL NewDiary();

// Open a diary.
//..............
VOID OpenDiary(LPBYTE lpDiary);

// Get the names of the 12 months for the locale.
//...............................................
BOOL GetMonthNames();

// Deallocate the memory for the month names.
//...........................................
VOID DeallocateMonthNames();

// CALLBACK procedure for create a New Diary dialog box.
//......................................................
LRESULT CALLBACK CreateDiaryProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Clear the diary entries.
//.........................
VOID ClearDiaryEntries(HWND hDlg);

// CALLBACK procedure for signing into your diary.
//................................................
LRESULT CALLBACK DiarySignInProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Change the pass phrase for a top secret diary.
//...............................................
VOID ChangeDiaryPassPhrase();

// CALLBACK procedure for setting a new password for a diary.
//...........................................................
LRESULT CALLBACK SetPasswordDiaryProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for getting the Admin Code to change where diary can be used.
//.................................................................................
LRESULT CALLBACK AdminCodeDiaryProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for Admin Code sign in. We have found we are on a
// different computer.
//.....................................................................
LRESULT CALLBACK AdminCodeSignInProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// CALLBACK procedure for the decrypt pke packet dialog box for a diary.
//......................................................................
LRESULT CALLBACK DecryptPkePacketDiaryProc(HWND hDlg, UINT uiMsg, WPARAM wParam, 
										   LPARAM lParam);

// Create and sort the diary index file.
//......................................
BOOL CreateDiaryIndexFile();

// Setup the secret key to use for the diary.
//...........................................
BOOL SetupDiaryKey(LPBYTE lpKeyId);

// Setup the random number generators for encrypting the diary or diary page
// and our chat procedures.
//...........................................................................
VOID SetupDiaryRngs(DWORD dwModNBytes);

// Setup the arrays for use by the Rngs.
//......................................
VOID SetupDiaryArrays();

// Delete the old diary pages from the diary file.
//................................................
BOOL DeleteOldDiaryPages();

// CALLBACK procedure for the diary page.
//.......................................
LRESULT CALLBACK DiaryPageProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Add items to the tree view control.
//....................................
BOOL AddItemsToTreeView();

// Create tree view.
//..................
BOOL CreateTreeView();

// Set the local date and time for the diary page.
//................................................
VOID SetLocalDateTime(HWND hDlg);

// Check to see if the page has been modified.
//............................................
BOOL PageModified(HWND hDlg);

// Clear a diary page.
//....................
VOID ClearDiaryPage(HWND hDlg);

// Callback function for streaming a diary page into the rich text window.
//........................................................................
DWORD CALLBACK EditStreamPageInCallback(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG FAR *pcb);

// Display a diary page.
//......................
VOID DisplayDiaryPage(HWND hDlg, LPNMTREEVIEW lptv);

// Trap messages to dialog boxes to trap the enter key for our treeview control.
//..............................................................................
LRESULT CALLBACK TrapDlgMsgInput(int nCode, WPARAM wParam, LPARAM lParam);

// Encipher the components of the secret key in memory.
//.....................................................
BOOL EncComponents();

// Decipher the components of the secret key in memory.
//.....................................................
VOID DecComponents();

// CALLBACK procedure for entering registration information. New Procedure.
//.........................................................................
LRESULT CALLBACK RegisterNewProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Save a journal page.
//.....................
VOID SaveMyPage(HWND hDlg);

// Check to see if we are online or not.
//......................................
BOOL WeAreOnline(BOOL bShowDialog);

// We are online second edition.
//..............................
BOOL WeAreOnline2();

// Callback functions to stream data out of rich text window to a buffer in memory.
//.................................................................................
DWORD CALLBACK EditStreamPageOutCallback(DWORD dwCookie, LPBYTE pbBuff, LONG cb, 
										 LONG FAR *pcb);
// Setup the nickname.
//....................
VOID SetupNickName();

// Initialize the socket to listen on.
//....................................
BOOL InitializeSocket(HWND hStatusWin);

// Thread for receiving packets.
//..............................
DWORD WINAPI ReceiveThread(LPVOID lpParam);

// Thread for connecting to client.
//.................................
DWORD WINAPI ConnectThread(LPVOID lpParam);

// Send a message.
//................
VOID SendMyMsg(struct sockaddr_in *addr, void *buf, int iLen);

// Send an ack message.
//.....................
VOID SendAckMsg(struct sockaddr_in *addr, void *buf, int iLen);

// Send an Type message.
//.....................
VOID SendTypeMsg(struct sockaddr_in *addr, void *buf, int iLen);

// Setup the command buttons for chating.
//.......................................
VOID SetupChatButtons();

// Send chat message.
//...................
VOID SendChat();

// Thread for sending packets.
//............................
DWORD WINAPI SendThread(LPVOID lpParam);

// Compare two strings in memory.
// Returns 0 if the two are equal. 1 if destination is 
// larger than the source. -1 if destination is smaller
// than the source. 0 is the same as zero flag set. 1 is
// the same as carry flag set. -1 is the same as carry
// and zero flags clear.
//.....................................................
DWORD MpCompareStrings(LPBYTE lpSource, LPBYTE lpDestination, DWORD dwByteCount);

// Encrypt and send a message.
//............................
VOID EncryptAndSendMsg();

// Get the user id of the chat key.
//.................................
BOOL ChatKeyUserID(LPBYTE lpKeyId);

// Set the character font for the middle panel.
//.............................................
VOID ClearMsg();

// Dialog box for displaying special instruction when deciphering a file.							   
//.......................................................................
LRESULT CALLBACK PutSpecialInstructionsProc(HWND hDlg, UINT uiMsg, WPARAM wParam, 
											LPARAM lParam);

// Find and replace hook procedure for centering the dialog boxes.
//................................................................
UINT CALLBACK MyFindHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam,LPARAM lParam);

// Process the find and replace dialog boxs.
//..........................................
VOID MyFindDlgBox();

// CALLBACK procedure for the permanent IP address dialog box.
//............................................................
LRESULT CALLBACK PermanentIPAddressProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Insert a smiley into a rich text edit control dialog box.
//..........................................................
LRESULT CALLBACK SmileyProc1(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK SmileyProc2(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK SmileyProc3(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Display the smiley in the rtf window.
//......................................
BOOL DisplayMySmiley(int iSmiley);

// QueryInterface items.
//......................
STDMETHODIMP MyQueryInterface(LPRICHEDITOLECALLBACK lpRichEditOleCallback, REFIID iid, 
							  LPVOID FAR* ppvObject);
STDMETHODIMP_(ULONG) MyAddRef(LPRICHEDITOLECALLBACK lpRichEditOleCallback);
STDMETHODIMP_(ULONG) MyRelease(LPRICHEDITOLECALLBACK lpRichEditOleCallback);
STDMETHODIMP MyContextSensitiveHelp(LPRICHEDITOLECALLBACK lpRichEditOleCallback, 
									BOOL fEnterMode);
STDMETHODIMP MyDeleteObject(LPRICHEDITOLECALLBACK lpRichEditOleCallback, LPOLEOBJECT lpoleobj);
STDMETHODIMP MyGetClipboardData(LPRICHEDITOLECALLBACK lpRichEditOleCallback, 
								CHARRANGE FAR *lpchrg, DWORD reco,
								LPDATAOBJECT FAR *lplpdataobj);
STDMETHODIMP MyGetContextMenu(LPRICHEDITOLECALLBACK lpRichEditOleCallback, WORD seltype, 
							  LPOLEOBJECT lpoleobj,
							  CHARRANGE FAR *lpchrg, HMENU FAR *lphmenu);
STDMETHODIMP MyGetDragDropEffect(LPRICHEDITOLECALLBACK lpRichEditOleCallback, BOOL fDrag, 
								 DWORD grfKeyState, LPDWORD pdwEffect);
STDMETHODIMP MyGetInPlaceContext(LPRICHEDITOLECALLBACK lpRichEditOleCallback, 
								 LPOLEINPLACEFRAME FAR * lplpFrame,
								 LPOLEINPLACEUIWINDOW FAR * lplpDoc,
								 LPOLEINPLACEFRAMEINFO lpFrameInfo);
STDMETHODIMP MyGetNewStorage(LPRICHEDITOLECALLBACK lpRichEditOleCallback, 
							 LPSTORAGE FAR *lplpstg);
STDMETHODIMP MyQueryAcceptData(LPRICHEDITOLECALLBACK lpRichEditOleCallback, 
							   LPDATAOBJECT lpdataobj,
							   CLIPFORMAT FAR * lpcfFormat, DWORD reco,
							   BOOL fReally, HGLOBAL hMetaPict);
STDMETHODIMP MyQueryInsertObject(LPRICHEDITOLECALLBACK lpRichEditOleCallback, 
								 LPCLSID lpclsid, LPSTORAGE lpstg, LONG cp);
STDMETHODIMP MyShowContainerUI(LPRICHEDITOLECALLBACK lpRichEditOleCallback, BOOL fShow);

// Initiate the IRichEditOleCallbackVtbl interface.
//.................................................
VOID InitiateRichEditOleCallbackInterface();

// Setup the rich exit ole callback function.
//...........................................
VOID SetupOleCallback(HWND hDlg, int iControlID);

// ReplaceColor
//
// Author    : Dimitri Rochette drochette@ltezone.net
// Specials Thanks to Joe Woodbury for his comments and code corrections
//
// Includes  : Only <windows.h>
//
// hBmp	     : Source Bitmap
// cOldColor : Color to replace in hBmp
// cNewColor : Color used for replacement
// hBmpDC    : DC of hBmp ( default NULL ) could be NULL if hBmp is not selected
//
// Retcode   : HBITMAP of the modified bitmap or NULL for errors
//
//..............................................................................
HBITMAP ReplaceColor(HBITMAP hBmp, COLORREF cOldColor, COLORREF cNewColor, HDC hBmpDC);

// Insert a picture into a rich text edit control.
//................................................
VOID InsertPicture();

// Check for an insert smileys into the top panel.
//................................................
VOID CheckandInsertSmileys();

// My calculations for a bitmap.
//..............................
int MyCalcs(LONG lbm, int iConst, int iLogPixels);

// Load a bitmap file.
//....................
BOOL LoadMyBitmap(LPCTSTR lpBitmap);

// Do the random bits bin stats.
//..............................
VOID RandomBitsBinStats();

// Setup the smileys in a property sheet.
//.......................................
VOID GetMySmileys();

// Convert a file to a true one time pad file.
//............................................
VOID ConvertMyFile();

// Dialog box for asking what type of session key we want to use for a chat session.
//..................................................................................
LRESULT CALLBACK AskChatSessionKeyProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Hash buffer output for true one time pad file.
//...............................................
VOID HashBuffer(LPBYTE lpBuffer, DWORD dwBuffSize);

// Write, encrypt and send contents to clipboard.
//...............................................
VOID WriteEncryptClipboard();

// Decrypt and read clipboard in rtf window.
//..........................................
VOID DecryptReadClipboard();

// CALLBACK procedure for the Writing, Encrypting, and Sending to clipboard.
//..........................................................................
LRESULT CALLBACK WriteNoteProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Encrypt the message and place it in the clipboard.
//...................................................
BOOL EncryptMessageToClipboard();

// CALLBACK procedure for reading the contents of a message.
//..........................................................
LRESULT CALLBACK DecryptReadProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Determine if the use is an administrator or not on NT, 2000, and XP.
//.....................................................................
BOOL IsCurrentUserLocalAdministrator();

// Thread procedure to control the decrypt clipboard and read in
// rtf window.
//..............................................................
DWORD WINAPI DecryptClipboardThread(HWND hWnd);

// Retrieve all of the programs configuration and registration data.
// It could be in the registry or in a cfg file.
//..................................................................
BOOL GetTscConfigData();

// Read the cfg file into memory.
//...............................
BOOL ReadMyCfgFile();

// Write the cfg file to disk.
//............................
BOOL WriteMyCfgFile();

// Get the current user values from the registry.
//...............................................
BOOL GetUserValues();

// Setup the registry entries for the file icons.
//...............................................
BOOL SetupRegistryEntries();

// Remove the registry entries since this is not our computer.
//............................................................
VOID RemoveRegistryEntries();

// Set a registry entry.
//......................
BOOL SetRegistryEntry(LPCTSTR lpSubKey, LPCTSTR lpValue1, LPCTSTR lpValue2,
					  LPCTSTR lpIconNumber, LPBOOL lpRemove);

// Delete registry entry.
//.......................
VOID DeleteRegistryEntry(LPCTSTR lpSubKey1, LPCTSTR lpSubKey2, BOOL bRemove);

// Select the style of underline we will use.
//...........................................
LRESULT CALLBACK SelectUnderlineProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Calculate a SHA512 digest for a file.
//......................................
BOOL FileSha512(LPBYTE lpShaFile, LPBYTE lpShaForFile, LPBYTE lpShaAppend,
				DWORD dwAppendLength);

// CALLBACK procedure for displaying the final results of checking a file's Sha512 signature.
//...........................................................................................
LRESULT CALLBACK CheckFile512Proc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// Set the correct user lexicon files depending on the dictionary selected.
//.........................................................................
BOOL SetUserLexiconFiles();
